/*==============================================================================
This do file brings in state level data on migration from the March Supplement
to the CPS 

Source of data used in this dofile: 
March CPS, IPUMS-USA, 1982-2012s

Notes: 
For the 1985,1995,2005, migration is over the previous 5 years: 
For all other years, migration is over 1 year
==============================================================================*/

clear
set more off 

cd "/scratch/public/hysteresis_files/IPUMS CPS Data"

! uncompress cps_00149.dat.Z

do cps_00149.do

* ==============================================================================
* Create regions
* ==============================================================================

gen region = .
replace region=	840004 if statefip == 1
replace region=	840009 if statefip == 2
replace region=	840008 if statefip == 4
replace region=	840005 if statefip == 5
replace region=	840010 if statefip == 6
replace region=	840008 if statefip == 8
replace region=	840001 if statefip == 9
replace region=	840003 if statefip == 10
replace region=	840003 if statefip == 11
replace region=	840003 if statefip == 12
replace region=	840003 if statefip == 13
replace region=	840003 if statefip == 14
replace region=	840009 if statefip == 15
replace region=	840008 if statefip == 16
replace region=	840006 if statefip == 17
replace region=	840006 if statefip == 18
replace region=	840007 if statefip == 19
replace region=	840007 if statefip == 20
replace region=	840004 if statefip == 21
replace region=	840005 if statefip == 22
replace region=	840001 if statefip == 23
replace region=	840003 if statefip == 24
replace region=	840001 if statefip == 25
replace region=	840006 if statefip == 26
replace region=	840007 if statefip == 27
replace region=	840004 if statefip == 28
replace region=	840007 if statefip == 29
replace region=	840008 if statefip == 30
replace region=	840007 if statefip == 31
replace region=	840008 if statefip == 32
replace region=	840001 if statefip == 33
replace region=	840002 if statefip == 34
replace region=	840008 if statefip == 35
replace region=	840002 if statefip == 36
replace region=	840003 if statefip == 37
replace region=	840007 if statefip == 38
replace region=	840006 if statefip == 39
replace region=	840005 if statefip == 40
replace region=	840009 if statefip == 41
replace region=	840002 if statefip == 42
replace region=	840001 if statefip == 44
replace region=	840003 if statefip == 45
replace region=	840007 if statefip == 46
replace region=	840004 if statefip == 47
replace region=	840005 if statefip == 48
replace region=	840008 if statefip == 49
replace region=	840001 if statefip == 50
replace region=	840003 if statefip == 51
replace region=	840009 if statefip == 53
replace region=	840003 if statefip == 54
replace region=	840006 if statefip == 55
replace region=	840008 if statefip == 56

*Migration 

gen migplac_wvs_region =.

foreach var of varlist migsta1 migsta5  {
	
	replace migplac_wvs_region=	840004 if `var' == 1
	replace migplac_wvs_region=	840009 if `var' == 2
	replace migplac_wvs_region=	840008 if `var' == 4
	replace migplac_wvs_region=	840005 if `var' == 5
	replace migplac_wvs_region=	840010 if `var' == 6
	replace migplac_wvs_region=	840008 if `var' == 8
	replace migplac_wvs_region=	840001 if `var' == 9
	replace migplac_wvs_region=	840003 if `var' == 10
	replace migplac_wvs_region=	840003 if `var' == 11
	replace migplac_wvs_region=	840003 if `var' == 12
	replace migplac_wvs_region=	840003 if `var' == 13
	replace migplac_wvs_region=	840003 if `var' == 14
	replace migplac_wvs_region=	840009 if `var' == 15
	replace migplac_wvs_region=	840008 if `var' == 16
	replace migplac_wvs_region=	840006 if `var' == 17
	replace migplac_wvs_region=	840006 if `var' == 18
	replace migplac_wvs_region=	840007 if `var' == 19
	replace migplac_wvs_region=	840007 if `var' == 20
	replace migplac_wvs_region=	840004 if `var' == 21
	replace migplac_wvs_region=	840005 if `var' == 22
	replace migplac_wvs_region=	840001 if `var' == 23
	replace migplac_wvs_region=	840003 if `var' == 24
	replace migplac_wvs_region=	840001 if `var' == 25
	replace migplac_wvs_region=	840006 if `var' == 26
	replace migplac_wvs_region=	840007 if `var' == 27
	replace migplac_wvs_region=	840004 if `var' == 28
	replace migplac_wvs_region=	840007 if `var' == 29
	replace migplac_wvs_region=	840008 if `var' == 30
	replace migplac_wvs_region=	840007 if `var' == 31
	replace migplac_wvs_region=	840008 if `var' == 32
	replace migplac_wvs_region=	840001 if `var' == 33
	replace migplac_wvs_region=	840002 if `var' == 34
	replace migplac_wvs_region=	840008 if `var' == 35
	replace migplac_wvs_region=	840002 if `var' == 36
	replace migplac_wvs_region=	840003 if `var' == 37
	replace migplac_wvs_region=	840007 if `var' == 38
	replace migplac_wvs_region=	840006 if `var' == 39
	replace migplac_wvs_region=	840005 if `var' == 40
	replace migplac_wvs_region=	840009 if `var' == 41
	replace migplac_wvs_region=	840002 if `var' == 42
	replace migplac_wvs_region=	840001 if `var' == 44
	replace migplac_wvs_region=	840003 if `var' == 45
	replace migplac_wvs_region=	840007 if `var' == 46
	replace migplac_wvs_region=	840004 if `var' == 47
	replace migplac_wvs_region=	840005 if `var' == 48
	replace migplac_wvs_region=	840008 if `var' == 49
	replace migplac_wvs_region=	840001 if `var' == 50
	replace migplac_wvs_region=	840003 if `var' == 51
	replace migplac_wvs_region=	840009 if `var' == 53
	replace migplac_wvs_region=	840003 if `var' == 54
	replace migplac_wvs_region=	840006 if `var' == 55
	replace migplac_wvs_region=	840008 if `var' == 56

}

gen migration_yrs=1 
	replace migration_yrs=5 if year==1985|year==1995

gen migration = 1 if statefip!=migsta5  & migsta5>0 & migsta5<=56 & migration_yrs==5 //1 if individual moved domestically within state within last 5 years
	replace migration = 1 if statefip!=migsta1  & migsta1>0 & migsta1<=56 & migration_yrs==1  //1 if individual moved domestically within state within last 1 years

gen migplac = migsta5 if migration_yrs==5
	replace migplac = migsta1 if migration_yrs==1

gen weight = round(wtsupp)
save temp_precollapse.dta, replace

* ==============================================================================
* Collapse by state, Census region used in WVS, and year
* ==============================================================================

* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Inmigration - US States
* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use temp_precollapse.dta, clear

keep if (statefip!=migsta5 & migsta5>0 & migsta5<=56 & migration_yrs==5 )| ///
		(statefip!=migsta1  & migsta1>0 & migsta1<=56 & migration_yrs==1)  //keep domestic  movers only
collapse (sum) migration  [fw = weight], by(statefip year) //collapse by state movers are in now, this in inmigration to state

rename migration ts_inmigration

sort statefip
tempfile US_states_inmigration
save `US_states_inmigration.dta'

* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Inmigration - Census - regions
* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use temp_precollapse.dta , clear

keep if (statefip!=migsta5 & migsta5>0 & migsta5<=56 & migration_yrs==5 )| ///
(statefip!=migsta1  & migsta1>0 & migsta1<=56 & migration_yrs==1)  //keep domestic  movers only
collapse (sum) migration  [fw = weight], by(statefip region year) //collapse by state/WVS region movers are in now, this in inmigration to state
collapse (sum) migration , by(region year)

rename migration ts_inmigration

sort region
tempfile Census_regions_inmigration
save `Census_regions_inmigration.dta'

* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Outmigration - US States
* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

use temp_precollapse.dta , clear

keep if (statefip!=migsta5 & migsta5>0 & migsta5<=56 & migration_yrs==5 )| ///
(statefip!=migsta1  & migsta1>0 & migsta1<=56 & migration_yrs==1)  //keep domestic  movers only
collapse (sum) migration [fw = weight], by(migplac year) //collapse by state then left from, this is outmigration

rename migration ts_outmigration
rename migplac statefip

sort statefip
tempfile US_states_outmigration
save `US_states_outmigration.dta'

* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
* Outmigration - Census regions
* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
use temp_precollapse.dta , clear
	
keep if (statefip!=migsta5 & migsta5>0 & migsta5<=56 & migration_yrs==5 )| ///
(statefip!=migsta1  & migsta1>0 & migsta1<=56 & migration_yrs==1)  //keep domestic  movers only
collapse (sum) migration  [fw = weight], by(migplac migplac_wvs_region year) //collapse by state/WVS region then left from, this is outmigration
collapse (sum) migration , by(migplac_wvs_region year)

rename migration ts_outmigration
rename migplac region

sort region
tempfile Census_regions_outmigration
save `Census_regions_outmigration.dta'

* ==============================================================================
* Merge / Append above
* ==============================================================================
	
use `Census_regions_outmigration.dta'
merge 1:1 region year using `Census_regions_inmigration.dta', nogen
	
tempfile regions
save `regions.dta'
	
use  `US_states_outmigration.dta' 
merge 1:1 statefip year using `US_states_inmigration.dta', nogen

append using `regions.dta' 

gen nuts=statefip
replace nuts= region if statefip==.
	
drop region

rename ts_outmigration ts_outmigration_cps
rename ts_inmigration ts_inmigration_cps

gen ts_migration_yrs_cps=1 
	replace ts_migration_yrs_cps=5 if (year==1985|year==1995)

gen cps=1

tempfile cps_migration
save `cps_migration.dta'

* ==============================================================================
* Collapse Population Data
* ==============================================================================
	
use temp_precollapse.dta, clear
gen POP = 1 

collapse (sum) POP [fw = weight], by(statefip year)

tempfile state_POP
save `state_POP.dta'

use temp_precollapse.dta, clear
gen POP = 1 
collapse (sum) POP [fw = weight], by(region year)

append using 	`state_POP.dta'

gen nuts=statefip
replace nuts= region if statefip==.

merge 1:1 nuts year using `cps_migration.dta'

save "$dta_files/TS_US_CPS.dta", replace

! compress cps_00149.dat.Z

